/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import jemu.core.device.Device;
import jemu.core.device.IOPort;
import jemu.core.device.sound.JavaSound;
import jemu.core.device.sound.SoundDevice1;
import jemu.core.device.sound.SoundUtil1;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Desktop;

public class AY_3_8910_A
extends SoundDevice1 {
    public final double[] LOG_VOLUME = new double[]{0.08286408, 0.1171875, 0.1657282, 0.234375, 0.3314563, 0.46875, 0.6629126, 0.9375, 1.325825, 1.875, 2.65165, 3.75, 5.303301, 7.5, 10.6066, 15.0};
    public boolean register13Updated = false;
    public static boolean digiblast = false;
    public static int leftChannel;
    public static int rightChannel;
    public static int blasterA;
    public static int blasterB;
    protected int digibuffer = 20000;
    public static int digicount;
    public final int BDIR_MASK = 4;
    public final int BC2_MASK = 2;
    public final int BC1_MASK = 1;
    public final int PORT_A = 0;
    public final int PORT_B = 1;
    protected static final int INACTIVE = 0;
    protected static final int LATCH = 1;
    protected static final int READ = 2;
    protected static final int WRITE = 3;
    protected static final int[] STATES;
    protected static final int AFINE = 0;
    protected static final int ACOARSE = 1;
    protected static final int BFINE = 2;
    protected static final int BCOARSE = 3;
    protected static final int CFINE = 4;
    protected static final int CCOARSE = 5;
    protected static final int NOISEPERIOD = 6;
    protected static final int ENABLE = 7;
    protected static final int AVOL = 8;
    protected static final int BVOL = 9;
    protected static final int CVOL = 10;
    protected static final int EFINE = 11;
    protected static final int ECOARSE = 12;
    protected static final int ESHAPE = 13;
    protected static final int REG_PORTA = 14;
    protected static final int REG_PORTB = 15;
    protected static final int ENABLE_A = 1;
    protected static final int ENABLE_B = 2;
    protected static final int ENABLE_C = 4;
    protected static final int NOISE_A = 8;
    protected static final int NOISE_B = 16;
    protected static final int NOISE_C = 32;
    protected static final int PORT_A_OUT = 64;
    protected static final int PORT_B_OUT = 128;
    protected static final int NOISE_ALL = 56;
    protected static final int A = 0;
    protected static final int B = 1;
    protected static final int C = 2;
    protected static final int NOISE = 3;
    protected static final int ENVELOPE = 4;
    protected int step = 32768;
    protected int[] regs = new int[16];
    protected int selReg = 0;
    protected int bdirBC2BC1 = 0;
    protected int state = 0;
    protected int clockSpeed = 1000000;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0)};
    protected int[] envelope = new int[3];
    protected int[] output = new int[4];
    protected int[] count = new int[5];
    protected int[] period = new int[5];
    protected int[] volume = new int[5];
    protected int outN;
    protected int random = 1;
    protected int countEnv;
    protected int hold;
    protected int alternate;
    protected int attack;
    protected int holding;
    protected int updateStep;
    public static boolean changeformat;
    public int[] clocks = new int[]{1000000, 2000000, 4000000};
    public boolean isStereo = false;
    protected boolean mono = false;
    protected boolean inverted = false;
    int pla;
    int plb;
    int plc;
    int pda;
    int pdb;
    int pdc;
    final int delay = 1000;
    public static int chanA;
    public static int chanB;
    public static int chanC;
    static int[] chans;
    Double out;
    int monochannel;
    public static boolean build;
    public static boolean tape;
    int[] circlebuffer = new int[1600];
    int writepos = 1599;
    int readpos = 0;

    public AY_3_8910_A() {
        super("AY-3-8910/2/3 Programmable Sound Generator");
        int pufferSize = Settings.getInt("audio_puffersize", 4096);
        this.player = SoundUtil1.getSoundPlayer1(pufferSize, true);
        this.player.setFormat(2);
    }

    public void setClockSpeed(int value) {
        this.clockSpeed = value;
        this.updateStep = (int)((long)this.step * 8L * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
        this.output[3] = 255;
        for (int i = 0; i <= 4; ++i) {
            this.period[i] = this.count[i] = this.updateStep;
        }
        this.period[4] = 0;
        this.count[3] = Short.MAX_VALUE;
    }

    public void changeClockSpeed(int value) {
        if (value < 1) {
            value = 1996092;
        }
        this.clockSpeed = value & 0xFFFFFFFF;
        this.updateStep = (int)((long)this.step * 8L * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
    }

    public void setSelectedRegister(int value) {
        this.selReg = value & 0xF;
    }

    public int getSelectedRegister() {
        return this.selReg;
    }

    public void setBDIR_BC2_BC1(int value, int dataValue) {
        if (this.bdirBC2BC1 != value) {
            this.bdirBC2BC1 = value;
            this.state = STATES[this.bdirBC2BC1];
            this.writePort(0, dataValue);
        }
    }

    public int getBDIR_BC2_BC1() {
        return this.bdirBC2BC1;
    }

    @Override
    public int readPort(int port) {
        if (this.selReg != 0) {
            return this.state == 2 ? this.readRegister(this.selReg) : 255;
        }
        return 255;
    }

    public void setInverted(boolean i) {
        this.inverted = i;
    }

    @Override
    public void writePort(int port, int value) {
        if (port >= 63488 && port <= 63999) {
            this.mono = true;
            if (this.inverted) {
                if (port >= 63616 && port <= 63631) {
                    this.selReg = value & 0xF;
                } else {
                    this.setRegister(this.selReg, value);
                }
            } else if (port >= 63616 && port <= 63631) {
                this.setRegister(this.selReg, value);
            } else {
                this.selReg = value & 0xF;
            }
            return;
        }
        this.mono = false;
        if (port == 64510 || port == 64494) {
            return;
        }
        switch (this.state) {
            case 1: {
                this.selReg = value & 0xF;
                break;
            }
            case 3: {
                this.setRegister(this.selReg, value);
            }
        }
    }

    public int getRegister(int index) {
        return this.regs[index];
    }

    public int readRegister(int index) {
        return index < 14 ? this.regs[index] : this.ports[index - 14].read();
    }

    public boolean registerUpdated() {
        return this.register13Updated;
    }

    public void resetUpdated() {
        this.register13Updated = false;
    }

    public void resetRegisters() {
        for (int r = 0; r < 16; ++r) {
            this.setRegister(r, 0);
        }
        this.setRegister(0, 90);
        this.setRegister(2, 90);
        this.setRegister(4, 90);
        this.setRegister(6, 1);
        this.setRegister(7, 63);
        this.setRegister(11, 13);
        this.setRegister(13, 24);
    }

    public void setRegister(int index, int value) {
        if (index == 13) {
            this.register13Updated = true;
        }
        if (index < 14) {
            if (index == 13 || this.regs[index] != value) {
                this.regs[index] = value;
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int val = ((this.regs[((index >>= 1) << 1) + 1] & 0xF) << 8 | this.regs[index << 1]) * this.updateStep;
                        int last = this.period[index];
                        val = val < 32768 ? 32768 : val;
                        this.period[index] = val;
                        int newCount = this.count[index] - (val - last);
                        this.count[index] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 6: {
                        int val = (value & 0x1F) * this.updateStep;
                        int last = this.period[3];
                        val = (val *= 2) == 0 ? this.updateStep : val;
                        this.period[3] = val;
                        int newCount = this.count[3] - (val - last);
                        this.count[3] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.volume[index - 8] = (value & 0x10) == 0 ? value & 0xF : this.volume[4];
                        break;
                    }
                    case 11: 
                    case 12: {
                        int val = (this.regs[12] << 8 | this.regs[11]) * this.updateStep << 1;
                        int last = this.period[4];
                        this.period[4] = val;
                        int newCount = this.count[4] - (val - last);
                        this.count[4] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 13: {
                        int n = this.attack = (value & 4) == 0 ? 0 : 15;
                        if ((value & 8) == 0) {
                            this.hold = 1;
                            this.alternate = this.attack;
                        } else {
                            this.hold = value & 1;
                            this.alternate = value & 2;
                            if (this.hold != 0) {
                                this.attack = this.alternate;
                            }
                        }
                        this.count[4] = this.period[4];
                        this.countEnv = 15;
                        this.holding = 0;
                        int vol = this.volume[4] = this.attack ^ 0xF;
                        if ((this.regs[8] & 0x10) != 0) {
                            this.volume[0] = vol;
                        }
                        if ((this.regs[9] & 0x10) != 0) {
                            this.volume[1] = vol;
                        }
                        if ((this.regs[10] & 0x10) == 0) break;
                        this.volume[2] = vol;
                        break;
                    }
                }
            }
        } else {
            this.ports[index - 14].write(value);
        }
    }

    public void writeAudio() {
        int add;
        int enable = this.regs[7];
        if ((enable & 1) != 0) {
            if (this.count[0] <= this.step) {
                this.count[0] = this.count[0] + this.step;
            }
            this.output[0] = 1;
        }
        if ((enable & 2) != 0) {
            if (this.count[1] <= this.step) {
                this.count[1] = this.count[1] + this.step;
            }
            this.output[1] = 1;
        }
        if ((enable & 4) != 0) {
            if (this.count[2] <= this.step) {
                this.count[2] = this.count[2] + this.step;
            }
            this.output[2] = 1;
        }
        this.outN = this.output[3] | enable;
        if ((enable & 0x38) == 56 && this.count[3] <= this.step) {
            this.count[3] = this.count[3] + this.step;
        }
        int[] cnt = new int[3];
        int left = this.step;
        do {
            add = this.count[3] < left ? this.count[3] : left;
            for (int chan = 0; chan <= 2; ++chan) {
                int chcnt = this.count[chan];
                if ((this.outN & 8 << chan) != 0) {
                    int val;
                    block42: {
                        int n = val = this.output[chan] == 0 ? cnt[chan] : cnt[chan] + chcnt;
                        if ((chcnt -= add) <= 0) {
                            int p = this.period[chan];
                            do {
                                if ((chcnt += p) > 0) {
                                    int n2 = chan;
                                    this.output[n2] = this.output[n2] ^ 1;
                                    if (this.output[n2] != 0) {
                                        val += p - chcnt;
                                    }
                                    break block42;
                                }
                                val += p;
                            } while ((chcnt += p) <= 0);
                            if (this.output[chan] == 0) {
                                val -= chcnt;
                            }
                        } else if (this.output[chan] != 0) {
                            val -= chcnt;
                        }
                    }
                    cnt[chan] = val;
                } else if ((chcnt -= add) <= 0) {
                    int p = this.period[chan];
                    do {
                        if ((chcnt += p) <= 0) continue;
                        int n = chan;
                        this.output[n] = this.output[n] ^ 1;
                        break;
                    } while ((chcnt += p) <= 0);
                }
                this.count[chan] = chcnt;
            }
            this.count[3] = this.count[3] - add;
            if (this.count[3] > 0) continue;
            int val = this.random + 1;
            if ((val & 2) != 0) {
                this.output[3] = this.output[3] ^ 0xFF;
                this.outN = this.output[3] | enable;
            }
            this.random = (this.random & 1) == 0 ? this.random >> 1 : (this.random ^ 0x28000) >> 1;
            this.count[3] = this.count[3] + this.period[3];
        } while ((left -= add) > 0);
        if (this.holding == 0 && this.period[4] != 0 && (this.count[4] = this.count[4] - this.step) <= 0) {
            int ce = this.countEnv;
            int p = this.period[4];
            do {
                --ce;
            } while ((this.count[4] = this.count[4] + p) <= 0);
            if (ce < 0) {
                if (this.hold != 0) {
                    if (this.alternate != 0) {
                        this.attack ^= 0xF;
                    }
                    this.holding = 1;
                    ce = 0;
                } else {
                    if (this.alternate != 0 && (ce & 0x10) != 0) {
                        this.attack ^= 0xF;
                    }
                    ce &= 0xF;
                }
            }
            this.countEnv = ce;
            int vol = this.volume[4] = ce ^ this.attack;
            if ((this.regs[8] & 0x10) != 0) {
                this.volume[0] = vol;
            }
            if ((this.regs[9] & 0x10) != 0) {
                this.volume[1] = vol;
            }
            if ((this.regs[10] & 0x10) != 0) {
                this.volume[2] = vol;
            }
        }
        int a = (int)(this.LOG_VOLUME[this.volume[0]] * (double)cnt[0]) >> 13;
        int b = (int)(this.LOG_VOLUME[this.volume[1]] * (double)cnt[1]) >> 13;
        int c = (int)(this.LOG_VOLUME[this.volume[2]] * (double)cnt[2]) >> 13;
        if (Desktop.psg1a.isShowing()) {
            if (this.pla <= this.volume[0]) {
                this.pla = this.volume[0];
            }
            if (this.pla > 0) {
                ++this.pda;
                if (this.pda >= 1000) {
                    this.pda = 0;
                    --this.pla;
                }
            }
            if (this.plb <= this.volume[1]) {
                this.plb = this.volume[1];
            }
            if (this.plb > 0) {
                ++this.pdb;
                if (this.pdb >= 1000) {
                    this.pdb = 0;
                    --this.plb;
                }
            }
            if (this.plc <= this.volume[2]) {
                this.plc = this.volume[2];
            }
            if (this.plc > 0) {
                ++this.pdc;
                if (this.pdc >= 1000) {
                    this.pdc = 0;
                    --this.plc;
                }
            }
            Desktop.psg1a.setValue(this.pla);
            Desktop.psg1b.setValue(this.plb);
            Desktop.psg1c.setValue(this.plc);
        }
        AY_3_8910_A.feed(a, b, c);
        leftChannel = a + b;
        rightChannel = b + c;
        if (this.mono && !this.isStereo) {
            this.out = ((double)a + (double)b + (double)c) * 0.85;
            leftChannel = rightChannel = (this.monochannel = (int)Math.round(this.out));
        }
        this.soundOutput();
    }

    public static int[] feed(int a, int b, int c) {
        if (chanA <= a) {
            AY_3_8910_A.chans[0] = chanA = a;
        }
        if (chanB <= b) {
            AY_3_8910_A.chans[1] = chanB = b;
        }
        if (chanC <= c) {
            AY_3_8910_A.chans[2] = chanC = c;
        }
        return chans;
    }

    public void vu() {
    }

    public void setClock(int index) {
        this.changeClockSpeed(this.clocks[index]);
    }

    public void setStereo(boolean stereo) {
        this.isStereo = stereo;
    }

    public void setReadDevice(int port, Device device, int readPort) {
        this.ports[port].setInputDevice(device, readPort);
    }

    public void soundOutput() {
        this.player.writeStereo(leftChannel, rightChannel);
        if (changeformat) {
            changeformat = false;
            this.changePlayer();
            CPC.replay = true;
        }
    }

    public void changePlayer() {
        if (build) {
            this.player.init();
            this.changeClockSpeed(this.clockSpeed);
        }
        build = true;
    }

    void buffer_write(int val) {
        try {
            this.circlebuffer[this.writepos] = val;
            this.writepos = (this.writepos + 1) % this.circlebuffer.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int buffer_read() {
        try {
            int val = this.circlebuffer[this.readpos];
            this.readpos = (this.readpos + 1) % this.circlebuffer.length;
            return val;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setWriteDevice(int port, Device device, int writePort) {
        this.ports[port].setOutputDevice(device, writePort);
    }

    static {
        digicount = 0;
        STATES = new int[]{0, 1, 0, 2, 1, 0, 3, 1};
        changeformat = false;
        chans = new int[3];
        tape = false;
    }
}

